﻿using Aratek.TrustFinger;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data.Linq.Mapping;
using System.Data.Common;
using System.Data.Entity;
using SQLite.CodeFirst;
//using System.ComponentModel.DataAnnotations.Schema;
using System.ComponentModel.DataAnnotations;

namespace Demo
{
    public class DeviceItem
    {
        public string Name { get; set; }
        public int DeviceIndex { get; set; }
    }


    public class CaptureFingerprintItem
    {
        public FingerPosition FingerPosition { get; set; }
        public byte[] Bitmap { get; set; }
        public byte[] Fearture { get; set; }
        public int Qulity { get; set; }
       
    }

    public class IdentifyUser
    {
        public int Ranking { get; set; }

        
        public string UserID { get; set; }

        public string FirstName { get; set; }

        public string LastName { get; set; }

        public float Score { get; set; }

        public bool IsMatch { get; set; }
    }

    [Table(Name ="EnrollUsers")]
    public class EnrollUser :EventArgs
    {
        [Key]
        public int Id { get; set; }

        [StringLength(10)]
        public string UserId { get; set; }

        [StringLength(20)]
        public string FirstName { get; set; }

        [StringLength(20)]
        public string LastName { get; set; }


        //[DatabaseGenerated(DatabaseGeneratedOption.Computed)]
        //[SqlDefaultValue(DefaultValue = "DATETIME('now')")]
        public DateTime CreatedTime { get; set; }

        public int FingerPosition{get;set;}

        public string FingerPositionName { get; set; }

        public byte[] FingerData { get; set; }
    }

    public class TrustFingerDbContext : DbContext
    {
        public TrustFingerDbContext()
            : base("trustfinger") { }

        public virtual DbSet<EnrollUser> EnrollUser { get; set; }
        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            var sqliteConnectionInitializer = new SqliteCreateDatabaseIfNotExists<TrustFingerDbContext>(modelBuilder);
            Database.SetInitializer(sqliteConnectionInitializer);
        }
    }

    public class TrustFingerDbInitializer : SqliteDropCreateDatabaseWhenModelChanges<TrustFingerDbContext>
    {
        public TrustFingerDbInitializer(DbModelBuilder modelBuilder)
            : base(modelBuilder)
        { }

        protected override void Seed(TrustFingerDbContext context)
        {
            // Here you can seed your core data if you have any.
        }
    }

    public class FormatHelper
    {
        public static FingerPosition ConvertToFingerPosition(string name)
        {
            FingerPosition position = FingerPosition.UnKnow;
            Enum.TryParse<FingerPosition>(name, out position);
            return position;
        }
        public static string FormatFingerprintPosition(FingerPosition position)
        {
            string desc = string.Empty;
            switch(position)
            {
                case FingerPosition.UnKnow:
                    break;
                case FingerPosition.LeftIndexFinger:
                    desc = "Left Index Finger";
                    break;
                case FingerPosition.LeftLittleFinger:
                    desc = "Left Little Finger";
                    break;
                case FingerPosition.LeftMiddleFinger:
                    desc = "Left Middle Finger";
                    break;
                case FingerPosition.LeftRingFinger:
                    desc = "Left Ring Finger";
                    break;
                case FingerPosition.LeftThumb:
                    desc = "Left Thumb";
                    break;
                case FingerPosition.RightIndexFinger:
                    desc = "Right Index Finger";
                    break;
                case FingerPosition.RightLittleFinger:
                    desc = "Right Little Finger";
                    break;
                case FingerPosition.RightMiddleFinger:
                    desc = "Right Middle Finger";
                    break;
                case FingerPosition.RightRingFinger:
                    desc = "Right Ring Finger";
                    break;
                case FingerPosition.RightThumb:
                    desc = "Right Thumb";
                    break;
            }

            return desc;
        }
    }
}
